#include <iostream>
#include <string>
#include <nlohmann/json.hpp>  // 引入 nlohmann/json 库
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QObject>
#include <QString>
#include <QDebug>

using json = nlohmann::json;

class YourCppClass : public QObject {
    Q_OBJECT

public:
    YourCppClass();
    void fetchData(const QString &url);

private slots:
    void onReplyFinished(QNetworkReply* reply);

private:
    QNetworkAccessManager* networkManager;
};

YourCppClass::YourCppClass() {
    networkManager = new QNetworkAccessManager(this);
    connect(networkManager, SIGNAL(finished(QNetworkReply*)), this, SLOT(onReplyFinished(QNetworkReply*)));
}

void YourCppClass::fetchData(const QString &url) {
    QNetworkRequest request(QUrl(url));
    networkManager->get(request);
}

void YourCppClass::onReplyFinished(QNetworkReply* reply) {
    if (reply->error() == QNetworkReply::NoError) {
        QByteArray responseData = reply->readAll();
        QString responseStr(responseData);

        // 将 QByteArray 转换为 std::string 以供 nlohmann/json 使用
        std::string responseDataStr = responseStr.toStdString();

        try {
            // 使用 nlohmann/json 解析 JSON 数据
            json jsonObj = json::parse(responseDataStr);

            // 解析出数据 (根据实际的 JSON 格式)
            std::string username = jsonObj["username"].get<std::string>();
            std::string content = jsonObj["content"].get<std::string>();

            qDebug() << "Username:" << QString::fromStdString(username);
            qDebug() << "Content:" << QString::fromStdString(content);

        } catch (json::parse_error& e) {
            qDebug() << "JSON parse error:" << e.what();
        }
    } else {
        qDebug() << "Network error occurred:" << reply->errorString();
    }

    reply->deleteLater();
}

int main(int argc, char *argv[]) {
    // 简单示例程序初始化
    QCoreApplication app(argc, argv);
    
    YourCppClass yourClass;
    yourClass.fetchData("http://example.com/api");  // 替换为实际的 API URL

    return app.exec();
}

#include "YourCppClass.moc"
